var samplePageObj = {
  // 샘플 타이틀
  title: '모바일 환경 예제',
  subtitle: '모바일 환경에서 특정 열을 감추거나 보이게 합니다.',

  // 샘플 설명
  desc: '모바일 환경에서 특정 열을 감추거나 보이게 할 수 있습니다.'
    + '<br> 시트가 초기화 될 때 컬럼 설정에 입력된 HideMobile 속성 값을 통하여 해당 열을 감추거나 보여줄 수 있습니다.'
    + '<br> 아래 시트 내의 공급처, 부서, 다국어 선택 컬럼은 모바일 환경에서 보이지 않습니다.'
    + '<br>',

  // 객체 초기화 구문
  init: {
    Def: {
      Col: {
        RelWidth: 1,
        MinWidth: 60
      },
    },
    Cfg: {
      SearchMode: 0
    },
    Cols: [
      {
        Header: 'SEQ',
        Name: 'SEQ'

      },
      {
        Header: '이름',
        Name: 'sName',
        Type: 'Text',
        Align: 'Center'
      },
      {
        Header: '고유번호',
        Name: 'sId',
        Type: 'Text',
        RelWidth: 2
      },
      {
        Header: '공급처',
        Name: 'sCompany',
        Type: 'Text',
        Align: 'Center',
        Tip: '마우스 오른쪽 버튼으로 메뉴호출',
        Color: '#B5E7D2',
        HideMobile: 1
      },
      {
        Header: '부서',
        Name: 'sDepartment',
        Type: 'Text',
        Menu: '|경영지원팀|총무부서|영업팀|구매팀|전산팀|마케팅|인사',
        Align: 'Center',
        Tip: '마우스 오른쪽 버튼으로 메뉴호출',
        Color: '#B5E7D2',
        HideMobile: 1
      },
      {
        Header: '다국어 선택',
        Name: 'sLanguage',
        Type: 'Text',
        RelWidth: 2,
        Color: '#B5E7D2',
        HideMobile: 1
      },
      {
        Header: '주소',
        Name: 'sAddr',
        Type: 'Text',
        RelWidth: 5
      },
      {
        Header: 'sMoney',
        Name: 'sMoney',
        Type: 'Text',
        RelWidth: 5,
        Visible: 0
      },
      {
        Header: 'sComment',
        Name: 'sComment',
        Type: 'Text',
        RelWidth: 5,
        Visible: 0
      }
    ]
  },

  func: '',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },
  // 버튼 클릭시 기능 로직
  action: function (obj) {
  },

  // data
  data: [
    {
      sName: '황정열',
      sMoney: '5000',
      sComment: '코멘트를 입력해주세요',
      sId: '801221384251',
      sAddr: '서울특별시 구로구 가리봉동',
      sCompany: '한화',
      sDepartment: '인사',
      sLanguage: '영어'
    },
    {
      sName: '강대호',
      sMoney: '4700',
      sComment: '코멘트를 입력해주세요',
      sId: '807151852148',
      sAddr: '경기도 남양주시 도농동',
      sDepartment: '경영지원',
      sCompany: 'SK',
      sLanguage: '영어,일본어'
    },
    {
      sName: '김미경',
      sMoney: '3900',
      sComment: '코멘트를 입력해주세요',
      sId: '138206820',
      sAddr: '강원도 강릉시 강동면 모전리',
      sDepartment: '총무부서',
      sCompany: '현대',
      sLanguage: '영어'
    },
    {
      sName: '김선희',
      sMoney: '3400',
      sComment: '코멘트를 입력해주세요',
      sId: '6098204963',
      sAddr: '경기도 성남시 수정구 금토동',
      sDepartment: '영업팀',
      sCompany: '롯데',
      sLanguage: '영어,중국어'
    },
    {
      sName: '최세희',
      sMoney: '3200',
      sComment: '코멘트를 입력해주세요',
      sId: '405142384211',
      sAddr: '경기도 광주시 오포읍 신현리',
      sDepartment: '영업팀',
      sCompany: '현대기아',
      sLanguage: '영어,러시아어'
    },
    {
      sName: '이명희',
      sMoney: '2900',
      sComment: '코멘트를 입력해주세요',
      sId: '801221384251',
      sAddr: '경기도 수원시 권선구 고색동',
      sDepartment: '구매팀',
      sCompany: '식약청',
      sLanguage: '독일어,프랑스어'
    },
    {
      sName: '노효일',
      sMoney: '2300',
      sComment: '코멘트를 입력해주세요',
      sId: '506243051223',
      sAddr: '서울시 강남구 양재대로 55길10',
      sDepartment: '마케팅',
      sCompany: '인천공항',
      sLanguage: '영어'
    },
    {
      sName: '원영국',
      sMoney: '2800',
      sComment: '코멘트를 입력해주세요',
      sId: '2118204825',
      sAddr: '경기도 광주시 오포읍 신현리',
      sDepartment: '인사',
      sCompany: '제주공항',
      sLanguage: '영어,일본어'
    },
    {
      sName: '이지선',
      sMoney: '2400',
      sComment: '코멘트를 입력해주세요',
      sId: '1298261319',
      sAddr: '서울시 강남구 양재대로 55길10',
      sDepartment: '전산팀',
      sCompany: '부산공항',
      sLanguage: '영어'
    },
    {
      sName: '김상도',
      sMoney: '4000',
      sComment: '코멘트를 입력해주세요',
      sId: '507142063425',
      sAddr: '경기도 성남시 분당구 불정로 90',
      sDepartment: '영업팀',
      sCompany: '삼성전자',
      sLanguage: '스페인어'
    },
    {
      sName: '한보라',
      sMoney: '2800',
      sComment: '코멘트를 입력해주세요',
      sId: '2098200597',
      sAddr: '서울시 강남구 양재대로 55길10',
      sDepartment: '영업팀',
      sCompany: '엘지전자',
      sLanguage: '영어,아랍어'
    },
    {
      sName: '장태우',
      sMoney: '2800',
      sComment: '코멘트를 입력해주세요',
      sId: '5068272842',
      sAddr: '경상북도 안동시 강남동',
      sDepartment: '구매팀',
      sCompany: '본사',
      sLanguage: '영어'
    },
    {
      sName: '정필석',
      sMoney: '4000',
      sComment: '코멘트를 입력해주세요',
      sId: '1298263035',
      sAddr: '경기도 성남시 분당구 불정로 90',
      sDepartment: '전산팀',
      sCompany: '한화',
      sLanguage: '영어,그리스어'
    },
    {
      sName: '조성목',
      sMoney: '4100',
      sComment: '코멘트를 입력해주세요',
      sId: '410102263574',
      sAddr: '경기도 성남시 분당구 불정로 90',
      sDepartment: '마케팅',
      sCompany: '신한은행',
      sLanguage: '영어,스페인어'
    },
    {
      sName: '유봉근',
      sMoney: '4200',
      sComment: '코멘트를 입력해주세요',
      sId: '4098272390',
      sAddr: '전라북도 전주시 덕진구 강흥동',
      sDepartment: '구매팀',
      sCompany: '하나은행',
      sLanguage: '영어'
    },
    {
      sName: '오필환',
      sMoney: '3700',
      sComment: '코멘트를 입력해주세요',
      sId: '2118208651',
      sAddr: '경기도 수원시 권선구 고색동',
      sDepartment: '영업팀',
      sCompany: '롯데',
      sLanguage: '영어,중국어'
    },
    {
      sName: '송복석',
      sMoney: '3900',
      sComment: '코멘트를 입력해주세요',
      sId: '703301678921',
      sAddr: '경기도 성남시 분당구 불정로 90',
      sDepartment: '경영지원팀',
      sCompany: '인천공항',
      sLanguage: '영어,중국어,일본어'
    },
    {
      sName: '김남연',
      sMoney: '3600',
      sComment: '코멘트를 입력해주세요',
      sId: '206232384536',
      sAddr: '서울시 강남구 논현동',
      sDepartment: '마케팅',
      sCompany: 'SK',
      sLanguage: '영어'
    },
    {
      sName: '한혜선',
      sMoney: '2900',
      sComment: '코멘트를 입력해주세요',
      sId: '1298261319',
      sAddr: '서울시 강남구 논현동',
      sDepartment: '전산팀',
      sCompany: '삼성전자',
      sLanguage: '영어'
    },
    {
      sName: '조미미',
      sMoney: '2500',
      sComment: '코멘트를 입력해주세요',
      sId: '1108264699',
      sAddr: '서울시 강남구 논현동',
      sDepartment: '영업팀',
      sCompany: '한화',
      sLanguage: '영어'
    }
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
